#ifndef VIDEOPLAYER_H
#define VIDEOPLAYER_H

#include <QtWidgets>
#include <QLayout>
#include <gst/gst.h>

QT_BEGIN_NAMESPACE
class QAbstractButton;
QT_END_NAMESPACE

class VideoPlayer : public QWidget
{
    Q_OBJECT

public:
    VideoPlayer(QWidget *parent = nullptr);
    ~VideoPlayer();

    void load(const QUrl &url);

public slots:
    void play();
    void pause();
    void playPause();
    void stop();

private slots:
    void debugSlot();
    void disableRateControl(bool is_disabled);
    void useTcp(bool value);
    void setFrameMode(QString frameMode);
    void setRtspUrl(QString url);
    void setPlaybackSpeed(double speed);
    void setReversePlayback(bool isChecked);
    void seekBackward10();
    void seekForward10();
    void updatePosition();
    void seekToPosition();
    void nextFrame();

private:
    QList<QWidget *> videoDisplays = {};
    QWidget *playerWidget = nullptr;

    QAbstractButton *m_stopButton = nullptr;
    QAbstractButton *m_playButton = nullptr;
    QAbstractButton *m_seekBackwardButton = nullptr;
    QAbstractButton *m_seekForwardButton = nullptr;
    QAbstractButton *m_nextFrameButton = nullptr;

    QLabel *m_positionLabel = nullptr;
    QDateTimeEdit *m_position = nullptr;
    bool playing = false;
    GstElement *pipeline = nullptr;
    GstElement *video_sink = nullptr;

    bool use_tcp = true;
    bool rate_control = true;
    GstSeekFlags frame_seek_flag = GST_SEEK_FLAG_TRICKMODE;
    //QString rtspUrl = "rtsp://127.0.0.1:8554/test";
    QString rtspUrl = "rtsp://172.20.20.20/replay/RI1_CAM-1-VIDEO-1";
    double playSpeed = 1.0;
    bool reversePlayback = false;

    void print_status_of_all();

    void send_playback_speed_seek_event();
    void send_playback_speed_seek_event(gint64 offset);
    void send_playback_speed_seek_event(gint64 offset, bool absolute);
    void send_playback_speed_seek_event_absolute(gint64 position);

    void initGst();
    void setGstTestVideo();
    void setGstTestVideo(int pattern);
    void setGstFileVideo();
    void setGstRtspVideo();
};

#endif
